using System;
using System.Collections.Generic;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public static partial class ANALYSIS_DETAILManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static ANALYSIS_DETAIL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ANALYSIS_DETAIL_ID)
        {
            ANALYSIS_DETAIL objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ANALYSIS_DETAIL_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetItemsBySpecimen(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetItemsBySpecimen(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetItemsBySpecimenId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
        {
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            return objDB.GetItemsBySpecimenAnalysisId(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID);
        }

        public static List<ANALYSIS_DETAIL> GetItemsByFragment(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetItemsByFragment(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetItemsByFragmentExact(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetItemsByFragmentExact(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetBioAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetBioAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static List<ANALYSIS_DETAIL> GetFragmentAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.GetFragmentAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, ANALYSIS_DETAIL objSave)
        {
            Int32 objReturn = 0;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ANALYSIS_DETAIL_ID)
        {
            Boolean objReturn = false;
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ANALYSIS_DETAIL_ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, ANALYSIS_DETAIL objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ANALYSIS_DETAIL_ID);
        }

        public static void LoadBioLabResults(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int caseId)
        {
            ANALYSIS_DETAILDB objDB = new ANALYSIS_DETAILDB();
            objDB.LoadBioLabResults(CURRENT_USER, CURRENT_REGISTRY_ID, caseId);
        }

        #endregion
    }
}
